﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ZXing;

namespace  ZSMusic.Winform
{
    public partial class FrmQrCode : Form
    {
        public FrmQrCode(string text)
        {
            InitializeComponent();
            this.BackgroundImage = GenByZXingNet(text);
        }

        private Bitmap GenByZXingNet(string msg)
        {
            try
            {
                BarcodeWriter writer = new BarcodeWriter();
                writer.Format = BarcodeFormat.QR_CODE;
                writer.Options.Hints.Add(EncodeHintType.CHARACTER_SET, "UTF-8");//编码问题
                writer.Options.Hints.Add(EncodeHintType.ERROR_CORRECTION, ZXing.QrCode.Internal.ErrorCorrectionLevel.H);
                const int codeSizeInPixels = 240; //设置图片长宽
                writer.Options.Height = writer.Options.Width = codeSizeInPixels;
                writer.Options.Margin = 1;//设置边框
                ZXing.Common.BitMatrix bm = writer.Encode(msg);
                Bitmap img = writer.Write(bm);
                return img;
            }
            catch (Exception ex)
            {
                return GenByZXingNet(ex.Message);
            }
        }

        private void FrmQrCode_MouseClick(object sender, MouseEventArgs e)
        {
            this.Close();
        }
    }
}
